function [dist,vector,sl_dist,sl_vector] = punc2mat_test(punc_data)
%A Little function that takes the punc_data structure created by
%punc_metrics and convertes it into a matrix for easy manipulation.
%Synatax:   [distance,vector,sl_dist,sl_vector] = punc2mat(punc_data);
%Input:     punc_data = data structure created by punc_data
%
%Output:    dist = structure of distance matrices. distance(x).ch
%                   x = # of channels.  For distance(1).ch = a cell array,
%                   where the z is # of channels.  On x: Index, vertex, 2nd
%                   vertex, distance.  x y form an array.
%           vector = structure of vector matrices. vector(x).ch. x = # of
%                   channels.  For vector(1).ch = a cell array, where the z
%                   is # of channels.  x y is an cell of matrices.
%                   Essentially, x = # of vertices for current channel.  y
%                   is always going to be 1.  For each cell x y, there is a
%                   matrix of a b c, where c = # of channels - 2, the two
%                   points making up the base vector.  a b is an array,
%                   where on a: index, start_pt, base_termini,
%                   comp_termini, xy, xy_pos, xz, xz_pos, xyz. b = # of
%                   vertices in the comparision channel that is in the
%                   nhood of the vertex in the current channel.
%           sl_dist = distance structure for short list instead of the
%                   closest vertices.
%           sl_vector = vector structure for short list linstead o the
%                   closese vertices.
%           Note: cases were angle data is NaN is when the dot product and
%           the magnitudes of the base vectors are 0, essentially meaning
%           the two points are right on top of one another.  Might need to
%           deal with that at some point.

%lets get the distance matrices done.
h = waitbar(0,['Data Sets Analyzed: ',punc_data(1).filenames{1}],'position',[20 300 275 50]);    %initialize progress bar.
for i = 1:size(punc_data(1).filenames,2)     %step through channels
    h2 = waitbar(0,['Comparing Data Set: ',punc_data(1).filenames{1}],'position',[20 200 275 50]);    %initialize progress bar.
    for j = 1:size(punc_data(i).dist_verti,3) %step through the number of comparision channels.
        if ~isempty(cell2mat(punc_data(i).dist_verti(:,:,j)))   %proceed if this channel have values
            h3 = waitbar(0,'Distance Analyzed: 0');    %initialize progress bar.
            for k = 1:size(punc_data(i).dist_verti,1)   %step through vertices of curr channel
                %pull out and create a array of data for each vertices.
                curr_tmp = horzcat(repmat(k,size(punc_data(i).verti_match{k,1,j},1),1),punc_data(i).verti_match{k,1,j},...
                    punc_data(i).closest_pt{k,1,j},punc_data(i).dist_verti{k,1,j});
                %pull out and create a array of data for each vertices in the short list.
                sl_curr_tmp = horzcat(repmat(k,size(punc_data(i).sl_verti_match{k,1,j},1),1),punc_data(i).sl_verti_match{k,1,j},...
                    punc_data(i).short_list{k,1,j},punc_data(i).sl_dist{k,1,j});
                %now form the larger arrays
                if k==1     %first time through
                    dist_tmp = curr_tmp;
                    sl_dist_tmp = sl_curr_tmp;
                else        %all other times through
                    dist_tmp = vertcat(dist_tmp,curr_tmp);
                    sl_dist_tmp = vertcat(sl_dist_tmp,sl_curr_tmp);
                end
                waitbar(k/size(punc_data(i).dist_verti,1),h3,['Distance Analyzed: ',num2str(k)]);   %update progress
            end
            %clear tmp
            clear curr_tmp sl_curr_tmp
            %one array is ready for output
            dist(i).ch(:,:,j) = {dist_tmp};
            sl_dist(i).ch(:,:,j) = {sl_dist_tmp};
            %clear the tmp files
            clear dist_mp sl_dist_tmp
            close(h3);   %close progress bar
            waitbar(j/size(punc_data(i).dist_verti,3),h2,['Comparing Data Set: ',punc_data(1).filenames{j}]);   %update progress
        end
    end
    close(h2);
    waitbar(i/size(punc_data(1).filenames,2),h,['Data Sets Analyzed: ',punc_data(1).filenames{i}]);   %update progress
end
close(h);

%lets get cracking on the vector matrices
h = waitbar(0,['Data Sets Analyzed: ',punc_data(1).filenames{1}],'position',[20 300 275 50]);    %initialize progress bar.
for i = 1:size(punc_data(1).filenames,2)     %step through channels
    h2 = waitbar(0,['Comparing Data Set: ',punc_data(1).filenames{1}],'position',[20 200 275 50]);    %initialize progress bar.
    for j = 1:size(punc_data(i).verti_match,3)  %step through base channels/vectors
        if ~isempty(cell2mat(punc_data(i).verti_match(:,:,j)))   %proceed if this channel have values
            h3 = waitbar(0,'Vertex Vector Analyzed: 0');    %initialize progress bar.
            for k = 1:size(punc_data(i).verti_match,1)  %process every vertices
                for m = 1:size(punc_data(i).angles_xy,2)    %number of compared channels.
                    try
                        cell2mat(punc_data(i).angles_xy(:,m,j));    %proceed if the column is not empty, which is this errors
                        angles_tmp = [];
                        sl_angles_tmp = [];
                    catch
                        %process the nearest angles first
                        for l = 1:size(punc_data(i).verti_match{k,1,j},1)   %process all of the nearest points
                            x = size(punc_data(i).angles_xy{k,m,j}{l,:},1);      %number of vectors compared to the base vector
                            %for the array
                            curr_angles_tmp = horzcat(repmat(k,x,1),repmat(punc_data(i).vertices(k,:),x,1),...
                                repmat(punc_data(i).closest_pt{k,1,j}(l,:),x,1),punc_data(i).closest_pt{k,1,m},...
                                cell2mat(punc_data(i).angles_xy{k,m,j}(l,:)),cell2mat(punc_data(i).angles_pos_xy{k,m,j}(l,:)),...
                                cell2mat(punc_data(i).angles_xz{k,m,j}(l,:)),cell2mat(punc_data(i).angles_pos_xz{k,m,j}(l,:)),...
                                cell2mat(punc_data(i).angles_xyz{k,m,j}(l,:)));
                            if l==1     %first time through
                                angles_tmp = curr_angles_tmp;
                            else        %rest iterations
                                angles_tmp(:,:,l) = curr_angles_tmp;
                            end
                        end
                        %process the short list angles next
                        for l = 1:size(punc_data(i).short_list{k,1,j},1)   %process all of the nearest points
                            x = size(punc_data(i).sl_angles_xy{k,m,j}{l,:},1);      %number of vectors compared to the base vector
                            %for the array
                            curr_sl_angles_tmp = horzcat(repmat(k,x,1),repmat(punc_data(i).vertices(k,:),x,1),...
                                repmat(punc_data(i).short_list{k,1,j}(l,:),x,1),punc_data(i).short_list{k,1,m},...
                                cell2mat(punc_data(i).sl_angles_xy{k,m,j}(l,:)),cell2mat(punc_data(i).sl_angles_pos_xy{k,m,j}(l,:)),...
                                cell2mat(punc_data(i).sl_angles_xz{k,m,j}(l,:)),cell2mat(punc_data(i).sl_angles_pos_xz{k,m,j}(l,:)),...
                                cell2mat(punc_data(i).sl_angles_xyz{k,m,j}(l,:)));
                            if l==1     %first time through
                                sl_angles_tmp = curr_sl_angles_tmp;
                            else        %rest iterations
                                sl_angles_tmp(:,:,l) = curr_sl_angles_tmp;  %creates a matrix for all comparisions against a single base vector in chx.
                            end
                        end
                    end
                    %now store that matrix in a cell array for all channels
                    %analyzed
                    angles{:,:,m} = angles_tmp;
                    sl_angles{:,:,m} = sl_angles_tmp;
                    clear angles_tmp sl_angles_tmp
                end
                %now store that cell array in a cell array for all
                %verticies in that channel & output
                vector(i).ch(k,1,j) = {angles};
                sl_vector(i).ch(k,1,j) = {sl_angles};
                clear angles sl_angles
                waitbar(k/size(punc_data(i).verti_match,1),h3,['Vertex Vector Analyzed: ',num2str(k)]);   %update progress
            end
            close(h3);   %close progress bar
            waitbar(j/size(punc_data(i).verti_match,3),h2,['Comparing Data Set: ',punc_data(1).filenames{j}]);   %update progress
        end
    end
    close(h2);
    waitbar(i/size(punc_data(1).filenames,2),h,['Data Sets Analyzed: ',punc_data(1).filenames{i}]);   %update progress
end
close(h);